/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 1993 - 1999 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
/*
	File: CryTIFPluginUIWin.c

	C source file for MS-Windows specific code for CryTIFPlugin Plug-In
*/

#include "CryTIFPlugin.h"
#include "WinDialogUtils.h"

/*
#include "PITypes.h"
#include "PIgeneral.h"
#include "PIAbout.h"
#include "FormatUtilities.h"

#include <windows.h>

#include <stdlib.h>
#include "errno.h"
#include "string.h"

#include "WinUtil.h"
*/

/*****************************************************************************/

//BOOL WINAPI FormatProc(HWND hDlg, UINT wMsg, WPARAM wParam, LPARAM lParam);

/*****************************************************************************/

void DoAbout (AboutRecordPtr about)
{
	ShowAbout(about, hDllInstance, AboutID);
}

/****************************************************************************/
/* Example for ShowAlert() function which takes a string ID as parameter    */
/* and displays a message box                                               */
/****************************************************************************/

short ShowAlert (short stringID)
{
	char szMessage[256];
	char szTitle[128];

	LoadString((HINSTANCE)hDllInstance, stringID, szMessage, sizeof szMessage);
	LoadString((HINSTANCE)hDllInstance, 2, szTitle, sizeof szTitle);
	return  ( MessageBox(NULL, szMessage, szTitle, MB_OK | MB_ICONHAND) );

}


/* Initialization and termination code for window's dlls. */

// Win32 Change
#ifdef WIN32

// Every 32-Bit DLL has an entry point DLLInit

BOOL APIENTRY DLLInit(HANDLE hInstance, DWORD fdwReason, LPVOID lpReserved)
{

	if (fdwReason == DLL_PROCESS_ATTACH)
		hDllInstance = hInstance;

	return TRUE;   // Indicate that the DLL was initialized successfully.
}

#else
/* ------------------------------------------------
 *   Code from Borland's window's dll example code.
 * ------------------------------------------------
 */
#if defined(__BORLANDC__)
// Turn off warning: Parameter '' is never used; effects next function only
#pragma argsused
#endif

// Every DLL has an entry point LibMain and an exit point WEP.
int FAR PASCAL LibMain( HANDLE hInstance, WORD wDataSegment,
								   WORD wHeapSize, LPSTR lpszCmdLine )
{
	// Required when using Zortech; causes blink to include startup code
	extern __acrtused_dll;

	// The startup code for the DLL initializes the local heap (if there is one)
	// with a call to LocalInit which locks the data segment.
	if ( wHeapSize != 0 )
		UnlockData( 0 );

	hDllInstance = hInstance;
	return 1;   // Indicate that the DLL was initialized successfully.
}

int FAR PASCAL WEP(int nParam)
{
	switch  (nParam) {
	  case  WEP_SYSTEM_EXIT: // System shutdown in progress
	  case  WEP_FREE_DLL   : // DLL use count is 0
	  default :              // Undefined;  ignore
			return  1;
	}
}
#endif


